package com.omxx.cas.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.omxx.cas.utils.HttpClientUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Map;

@Controller
public class OAuthCodeController {

    //保存刷新令牌
    @Value("${cas-server.refreshToken}")
    private String refreshToken = null;

    @GetMapping("loginByCode")
    @ResponseBody
    public String accessToken(HttpServletRequest request, HttpServletResponse response){

        //response_type=code&client_id=<ID>&redirect_uri=<CALLBACK>
        //向CAS服务端请求地址
        String url = "https://sso.rghall.com.cn/oauth2.0/authorize";
        Map<String,String> params = new HashMap<>();
        //授权码模式
        params.put("response_type","code");
        //应用账号
        params.put("client_id","casJava");
        //回调地址，会将code携带到该地址
        params.put("redirect_uri","ip:port/receive");
        //发送GET请求
        String s = HttpClientUtils.getInstance().doGetRequest(url, null, params);
        return "login success";
    }

    @RequestMapping("receive")
    public void receive(HttpServletRequest request, @RequestParam("code") String code){
        //grant_type=authorization_code&client_id=<ID>&client_secret=<SECRET>&redirect_uri=<CALLBACK>&code=<CODE>
        //向CAS服务端请求地址
        String url = "https://sso.rghall.com.cn/oauth2.0/accessToken";
        Map<String,Object> params = new HashMap<>();
        //客户端模式
        params.put("grant_type","authorization_code");
        //应用账号
        params.put("client_id","casJava");
        //应用密钥
        params.put("client_secret","89s4Iw9yh7AJms4C8FD6SN6j0PlgD8eF2arK_F4cAXeOBjHDo0aSi7p0DSt5cJB0");
        //应用回调地址
        params.put("redirect_uri","ip:port/receive");
        //发送GET请求
        String s = HttpClientUtils.getInstance().doPost(url,null, params);
        //解析json
        JSONObject jsonObject = JSONObject.parseObject(s);
        //获取token
        String accessToken = jsonObject.getString("access_token");
        //获取刷新令牌，如果令牌失效，则通过刷新令牌获取
        String refreshToken = jsonObject.getString("refresh_token");
        //令牌失效时间
        String expiresIn = jsonObject.getString("expires_in");
        System.out.println("access_token:" + accessToken);
        System.out.println("refresh_token:" + refreshToken);
        System.out.println("expires_in:" + expiresIn);
        //获取session
        HttpSession session = request.getSession();
        //将accessToken保存到session中
        session.setAttribute("accessToken",accessToken);
        //为session设置失效时间
        session.setMaxInactiveInterval(10);
        //将refreshToken保存起来
        this.refreshToken = refreshToken;
    }

}
