package com.omxx.cas.controller;

import com.alibaba.fastjson.JSONObject;
import com.omxx.cas.utils.HttpClientUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Map;

@Controller
public class OAuthPasswordController {

    //保存刷新令牌
    @Value("${cas-server.refreshToken}")
    private String refreshToken = null;

    //为了演示方便，这里使用get请求，登录一般使用post
    @GetMapping("loginByPassword")
    @ResponseBody
    public String accessToken(String username,String password,HttpServletRequest request, HttpServletResponse response){

        //向CAS服务端请求地址
        String url = "https://sso.rghall.com.cn/oauth2.0/accessToken";
        Map<String,String> params = new HashMap<>();
        //密码模式
        params.put("grant_type","password");
        //应用账号
        params.put("client_id","casJava");
        //用户名
        params.put("username",username);
        //密码
        params.put("password",password);
        //发送GET请求
        String s = HttpClientUtils.getInstance().doGetRequest(url, null, params);
        //解析json
        JSONObject jsonObject = JSONObject.parseObject(s);
        //获取token
        String accessToken = jsonObject.getString("access_token");
        //获取刷新令牌，如果令牌失效，则通过刷新令牌获取
        String refreshToken = jsonObject.getString("refresh_token");
        //令牌失效时间
        String expiresIn = jsonObject.getString("expires_in");
        System.out.println("access_token:" + accessToken);
        System.out.println("refresh_token:" + refreshToken);
        System.out.println("expires_in:" + expiresIn);
        //获取session
        HttpSession session = request.getSession();
        //将accessToken保存到session中
        session.setAttribute("accessToken",accessToken);
        //为session设置失效时间
        session.setMaxInactiveInterval(10);
        //将refreshToken保存起来
        this.refreshToken = refreshToken;
        return s;

    }

    @GetMapping(value = "profile",produces="text/json;charset=utf-8")
    @ResponseBody
    public String profile(HttpServletRequest request, HttpServletResponse response){
        //从session中获取token
        Object accessToken = request.getSession().getAttribute("accessToken");
        if(accessToken ==null){
            //token已经失效，需要重新获取
            String url = "https://sso.rghall.com.cn/oauth2.0/accessToken";
            Map<String,String> map = new HashMap<>();
            //刷新令牌模式
            map.put("grant_type","refresh_token");
            //应用账号
            map.put("client_id","casJava");
            //yingyong密钥
            map.put("client_secret","89s4Iw9yh7AJms4C8FD6SN6j0PlgD8eF2arK_F4cAXeOBjHDo0aSi7p0DSt5cJB0");
            //刷新令牌
            map.put("refresh_token",refreshToken);
            //发送请求
            String s = HttpClientUtils.getInstance().doGetRequest(url, null, map);
            //解析返回结果
            JSONObject jsonObject = JSONObject.parseObject(s);
            //获取令牌
            accessToken = jsonObject.getString("access_token");
            //获取令牌失效时间
            String expiresIn = jsonObject.getString("expires_in");
            HttpSession session = request.getSession();
            //将token重新设置到session中
            session.setAttribute("accessToken",accessToken);
            //设置失效时间
            session.setMaxInactiveInterval(Integer.parseInt(expiresIn));
        }
        String url = "https://sso.rghall.com.cn/oauth2.0/profile";
        Map<String,String> params = new HashMap<>();
        params.put("access_token",accessToken + "");
        //获取个人信息
        String s = HttpClientUtils.getInstance().doGetRequest(url, null, params);
        return s;
    }


    //登出
    @GetMapping("logout")
    @ResponseBody
    public String logout(HttpServletRequest request, HttpServletResponse response){
        //将session设置为无效
        request.getSession().invalidate();
        String url = "https://sso.rghall.com.cn/logout";
        //向CAS服务端发送登出请求
        String s = HttpClientUtils.getInstance().doGet(url,null);
        return "logout success";
    }

}
